package gov.va.vinci.dart.biz;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

@Entity
@Table(name="requestadminlocationdocument", schema="hib") 
public class RequestAdminLocationDocument {

	private static Log log = LogFactory.getLog(RequestAdminLocationDocument.class);
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	private int id;
	
	@Column(name="requestid")
	private int requestId;
	
	@Column(name="locationid")
	private int locationId;
	
	@Column(name="documentid")
	private int documentId;

	@Column(name="groupid")
	private int groupId;

	@Column(name="active", columnDefinition = "BIT", length = 1)
	private boolean active;

	RequestAdminLocationDocument() {}
	
	public static RequestAdminLocationDocument create(Request request, Location location, Document document, Group reviewer) throws ValidationException {
		ValidationHelper.required("Request", request);
		ValidationHelper.required("Location", location);
		ValidationHelper.required("Document", document);
		ValidationHelper.required("Reviewer", reviewer);
	
		RequestAdminLocationDocument result = new RequestAdminLocationDocument();
		result.requestId = request.getId();
		result.locationId = location.getId();
		result.documentId = document.getId();
		result.groupId = reviewer.getId();
		result.active = true;

		DartObjectFactory.getInstance().getRequestAdminLocationDocumentDAO().save(result);
		return result;
	}
	
	public static List<RequestAdminLocationDocument> listByRequestId(final int requestId) {
		return DartObjectFactory.getInstance().getRequestAdminLocationDocumentDAO().listByRequestId(requestId);
	}

	public static List<RequestAdminLocationDocument> listByDocumentId(final int documentId) {
		return DartObjectFactory.getInstance().getRequestAdminLocationDocumentDAO().listByDocumentId(documentId);
	}
	
	public static List<RequestAdminLocationDocument> listByRequestIdAndGroupId(final int requestId, final int groupId) {
		return DartObjectFactory.getInstance().getRequestAdminLocationDocumentDAO().listByRequestIdAndGroupId(requestId, groupId);
	}
	
	public void delete() {
		log.debug("Deleting request admin location document");
		DartObjectFactory.getInstance().getRequestAdminLocationDocumentDAO().delete(this);
	}
	
	public int getId() {
		return id;
	}
	
	// TESTING ONLY
	public void setId(int id) {
		this.id = id;
	}
	
	public int getRequestId() {
		return requestId;
	}
	
	public int getLocationId() {
		return locationId;
	}
	
	public int getDocumentId() {
		return documentId;
	}

	public int getGroupId() {
		return groupId;
	}
	
	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}
}
